"""
HB_Move V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_Move
Description-US: Move Tool [SHIFT: Enable Quantizing with 100 Units, CTRL: Enable along Normal Mode]

This Script does following things:
- Enables the Movetool
- Show Axis if hidden
- Disable Quantizing if enabled and sets Movement back to 10 Units

- SHIFT: Enable Quantize Snapping and set it to 100 Units
- CTRL: Enables normal Mode to move selection on the Normals Axis

Video Tutorial:
https://youtu.be/eEcAttV56kE?t=21m
https://youtu.be/UlY-X5O137M?t=594

Name-DE: HB_Move
Description-DE: Move Tool [SHIFT: Aktiviere Quantize Snapping]

ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- New Highres Icon
- Fixed: Axis modes work now again
- Added: CTRL to enable Normal Move

"""

import c4d, math
from c4d.modules import snap
from c4d import documents, plugins


def tool():
    return plugins.FindPlugin(doc.GetAction(), c4d.PLUGINTYPE_TOOL)



def main():

    bc = c4d.BaseContainer()
    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):

        if bc[c4d.BFM_INPUT_QUALIFIER] ==0 : # NO MODIFIER
            c4d.CallCommand(200000088) # Move

            tool()[c4d.MDATA_AXIS_ROT]=0 #AXIS mode
            tool()[c4d.MDATA_AXIS_NORMAL_PSR]=False

            if (snap.IsQuantizeEnabled(doc)):

                c4d.CallCommand(c4d.QUANTIZE_ENABLED)

            snap.SetQuantizeStep(doc, None, c4d.QUANTIZE_MOVE,10)
            if not (c4d.IsCommandChecked(1016176)):
                c4d.CallCommand(1016176) # Show Axis

        if bc[c4d.BFM_INPUT_QUALIFIER] ==1 : # SHIFT
            c4d.CallCommand(200000088) # Move
            if not (snap.IsQuantizeEnabled(doc)):
                # Enable quantizing if not activated
                c4d.CallCommand(c4d.QUANTIZE_ENABLED)

            snap.SetQuantizeStep(doc, None, c4d.QUANTIZE_MOVE,100)

            if not (c4d.IsCommandChecked(1016176)):
                c4d.CallCommand(1016176) # Show Axis


        if bc[c4d.BFM_INPUT_QUALIFIER] ==2 : # CTRL

            c4d.CallCommand(200000088) # Move

            tool()[c4d.MDATA_AXIS_ROT]=5 #Normal mode
            tool()[c4d.MDATA_AXIS_NORMAL_PSR]=True

            if (snap.IsQuantizeEnabled(doc)):

                c4d.CallCommand(c4d.QUANTIZE_ENABLED)

            snap.SetQuantizeStep(doc, None, c4d.QUANTIZE_MOVE,10)
            if not (c4d.IsCommandChecked(1016176)):
                c4d.CallCommand(1016176) # Show Axis



if __name__=='__main__':
    main()
    c4d.EventAdd()